import { NextRequest, NextResponse } from "next/server"
import { wgApi } from "@/lib/wg-api"

export async function DELETE(
  request: NextRequest,
  { params }: { params: Promise<{ id: string }> }
) {
  try {
    const { id } = await params
    await wgApi.deleteClient(id)
    return NextResponse.json({ success: true })
  } catch (error) {
    console.error("Error deleting client:", error)
    const errorMessage = error instanceof Error ? error.message : "Failed to delete client"
    return NextResponse.json(
      { error: errorMessage },
      { status: 500 }
    )
  }
}

export async function PUT(
  request: NextRequest,
  { params }: { params: Promise<{ id: string }> }
) {
  try {
    const { id } = await params
    const body = await request.json()
    const { enabled } = body

    if (enabled === true) {
      await wgApi.enableClient(id)
    } else if (enabled === false) {
      await wgApi.disableClient(id)
    } else {
      return NextResponse.json(
        { error: "enabled field is required (true/false)" },
        { status: 400 }
      )
    }

    return NextResponse.json({ success: true })
  } catch (error) {
    console.error("Error updating client:", error)
    const errorMessage = error instanceof Error ? error.message : "Failed to update client"
    return NextResponse.json(
      { error: errorMessage },
      { status: 500 }
    )
  }
}

